package gov.va.vamf.scheduling.varutility.resources;


import gov.va.vamf.scheduling.varutility.clientapi.MobileHealthClientTestVersion;
import gov.va.vamf.scheduling.varutility.domain.*;
import gov.va.vamf.scheduling.varutility.testutility.IntegrationTestConfiguration;
import gov.va.vamf.scheduling.varutility.testutility.TestHelper;
import org.junit.*;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import java.net.URI;

public class VarUtilityRequestCriteriaResourceTest {

    private static MobileHealthClientTestVersion client;
    private static Client jerseyClient;
    private static String TEST_SITE_CODE = "test-site-code";

    @BeforeClass
    public static void startup() {
        client = TestHelper.createProviderClient();
        jerseyClient = client.getJerseyClient();
    }

    @AfterClass
    public static void destroy() {
        if (client != null) {
            client.getJerseyClient().close();
            client = null;
        }
    }

    @Before
    public void testPost() {
        RequestEligibilityCriteria postPayload = createCriteriaPayload(TEST_SITE_CODE);

        RequestEligibilityCriteria newCriteria = jerseyClient.target(getResourceUri(TEST_SITE_CODE, ""))
                .request().accept(MediaType.APPLICATION_JSON).post(Entity.entity(postPayload, MediaType.APPLICATION_JSON), RequestEligibilityCriteria.class);

        Assert.assertTrue(newCriteria != null);
        Assert.assertTrue(newCriteria.getId().equals(TEST_SITE_CODE));
    }

    private RequestEligibilityCriteria createCriteriaPayload(String siteCode) {
        RequestEligibilityCriteria criteria = new RequestEligibilityCriteria();

        CoreSettings cs = new CoreSettings();
        CustomRequestSettings crs = new CustomRequestSettings();
        cs.add(new CoreSetting("323", "PRIMARY CARE", "", null, null, true, 1, 1));
        cs.add(new CoreSetting("203", "AUDIOLOGY", "", null, null, true, 2, 2));
        cs.add(new CoreSetting("408", "OPTOMETRY", "", null, null, true, 2, 2));
        cs.add(new CoreSetting("502", "OUTPATIENT MENTAL HEALTH", "", null, null, true, 2, 2));
        SchedulingDays schedulingDays = new SchedulingDays();
        for (Day d: Day.values()) {
            SchedulingDay schedulingDay = new SchedulingDay();
            schedulingDay.setCanSchedule(false);
            schedulingDay.setDay(d);
            schedulingDay.setStartTime("");
            schedulingDay.setEndTime("");
            schedulingDays.add(schedulingDay);
        }
        crs.add(new CustomRequestSetting("CR1", "Express Care", false, schedulingDays, 1, 1));

        criteria.setId(siteCode);
        criteria.setRequestSettings(cs);
        criteria.setCustomRequestSettings(crs);

        return criteria;
    }

    @Test
    public void testFetch() {
        RequestEligibilityCriteria criteria = jerseyClient.target(getResourceUri(TEST_SITE_CODE, ""))
                .request().accept(MediaType.APPLICATION_JSON).get(RequestEligibilityCriteria.class);

        Assert.assertTrue(criteria != null);
        Assert.assertEquals(TEST_SITE_CODE, criteria.getId());
    }

    @Test
    public void testUpdate() {
        RequestEligibilityCriteria criteria = jerseyClient.target(getResourceUri(TEST_SITE_CODE, ""))
                .request().accept(MediaType.APPLICATION_JSON).get(RequestEligibilityCriteria.class);

        Assert.assertTrue(criteria != null);
        Assert.assertEquals(TEST_SITE_CODE, criteria.getId());

        criteria = jerseyClient.target(getResourceUri(TEST_SITE_CODE, TEST_SITE_CODE))
                .request().accept(MediaType.APPLICATION_JSON).put(Entity.entity(criteria, MediaType.APPLICATION_JSON), RequestEligibilityCriteria.class);

        Assert.assertTrue(criteria != null);
        Assert.assertEquals(TEST_SITE_CODE, criteria.getId());
    }

    private static URI getResourceUri(String siteCode, String id) {
        String uriFormat = String.format("%s/request-eligibility-criteria/site/%s" + (id.length() != 0 ? "/id/%s" : "%s"),
                IntegrationTestConfiguration.getServerBaseUri(), siteCode, id);

        return UriBuilder.fromUri(uriFormat).build();
    }
}
